//
//  File.swift
//  EcoWarriors
//
//  Created by Ria on 14/08/19.
//  Copyright © 2019 Ria. All rights reserved.
//

import UIKit

//MARK:- Variables

extension UIColor {
    static func rgb(red: CGFloat, green: CGFloat, blue: CGFloat) -> UIColor {
        return UIColor(red: red/255, green: green/255, blue: blue/255, alpha: 1)
    }
    
    static func mainBlue() -> UIColor {
        return UIColor.rgb(red: 0, green: 179, blue: 0)
    }
    
    static func googleRed() -> UIColor {
        return UIColor.rgb(red: 0, green: 141, blue: 0)
        
    }
    static func lightGreen() -> UIColor {
           return UIColor.rgb(red: 74, green: 196, blue: 47)
       }
    static func UltraLightGreen() -> UIColor {
            return UIColor.rgb(red: 160, green: 255, blue: 160)
        }

        static func lightGrey() -> UIColor {
            return UIColor.rgb(red: 230, green: 230, blue: 230)
        }
}



let screenRect = UIScreen.main.bounds
let screenWidth = screenRect.size.width
let screenHeight = screenRect.size.height

//MARK:- Class

class ContainerController: UIViewController {
    
    var menuController: MenuController!
    var centerController: UIViewController!
    var IsExpanded = false
    
    //MARK:- viewDidLoad
 
    override func viewDidLoad() {
        super.viewDidLoad()
        configureHomeController()
    }
    
    //MARK:- Page Functions
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    override var preferredStatusBarStyle: UIStatusBarStyle {
        return .lightContent
    }

    override var preferredStatusBarUpdateAnimation: UIStatusBarAnimation {
        return.slide
    }
    
    override var prefersStatusBarHidden: Bool {
        return IsExpanded
    }
 
    func configureHomeController() {
        let homeController = HomeController()
        homeController.delegate = self
        centerController = UINavigationController(rootViewController: homeController)
        view.addSubview(centerController.view)
        addChild(centerController)
        centerController.didMove(toParent: self)
    }
    
    func configureMenuController() {
        if menuController == nil {
            menuController = MenuController()
            menuController.delegate = self
            view.insertSubview(menuController.view, at: 0)
            addChild(menuController)
            menuController.didMove(toParent: self)
        }
    }
    
    //MARK:- Menu Functions
    
    func animatePanel(shouldExpand: Bool, menuOption: MenuOption?) {
        if shouldExpand {
            UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 0.8, initialSpringVelocity: 0, options: .curveEaseInOut, animations: {
                self.centerController.view.frame.origin.x = self.centerController.view.frame.width - 80
                }, completion: nil)
        } else {
            
            UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 0.8, initialSpringVelocity: 0, options: .curveEaseInOut, animations: {
                self.centerController.view.frame.origin.x = 0
            }) {(_) in
                guard let menuOption = menuOption else { return }
                self.didSelectMenuOption(menuOption: menuOption)
            }
        }
        
        animateStatusBar()
    }
    func didSelectMenuOption(menuOption: MenuOption) {
        switch menuOption {
        case .AboutUs:
            let controller = UINavigationController(rootViewController: AboutUsController())
            controller.modalPresentationStyle = .fullScreen
            present(controller, animated: true, completion:nil)
        case .UE:
            let controller = UINavigationController(rootViewController: UEController())
            controller.modalPresentationStyle = .fullScreen
            present(controller, animated: true, completion:nil)
        case .CP:
            let controller = UINavigationController(rootViewController: CPController())
            controller.modalPresentationStyle = .fullScreen
            present(controller, animated: true, completion:nil)
        case .RP:
            let controller = UINavigationController(rootViewController: RPController())
            controller.modalPresentationStyle = .fullScreen
            present(controller, animated: true, completion:nil)
        case .RS:
            let controller = UINavigationController(rootViewController: RSController())
            controller.modalPresentationStyle = .fullScreen
            present(controller, animated: true, completion:nil)
        case .JOT:
            let controller = UINavigationController(rootViewController: JOTController())
            controller.modalPresentationStyle = .fullScreen
            present(controller, animated: true, completion:nil)
        case .ContactUs:
            let controller = UINavigationController(rootViewController: ContactUsController())
            controller.modalPresentationStyle = .fullScreen
            present(controller, animated: true, completion:nil)
        }
    }
    
    func animateStatusBar() {
        UIView.animate(withDuration: 0.5, delay: 0, usingSpringWithDamping: 0.8, initialSpringVelocity: 0, options: .curveEaseInOut, animations: {
        self.setNeedsStatusBarAppearanceUpdate()
        }, completion: nil)
    }
}

//MARK:- Extension

extension ContainerController : HomeControllerDelegate {
    func handleMenuToggle(forMenuOption menuOption: MenuOption?) {
        if !IsExpanded {
            configureMenuController()
        }
        IsExpanded = !IsExpanded
        animatePanel(shouldExpand: IsExpanded, menuOption: menuOption)
    }
}

